import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import marketing1 from '/images/marketing-1.jpg'
import marketing2 from '/images/marketing-2.jpg'
import marketing3 from '/images/marketing-3.jpg'
import marketing4 from '/images/marketing-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: marketing1,
      title: 'Маркетинг'
    },
    {
      id: 2,
      src: marketing2,
      title: 'Аналитика'
    },
    {
      id: 3,
      src: marketing3,
      title: 'SMM'
    },
    {
      id: 4,
      src: marketing4,
      title: 'Реклама'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-marketing">
      <div className="slider-wrapper-marketing">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-marketing ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-marketing" />
            <div className="slide-overlay-marketing"></div>
            <div className="slide-content-marketing">
              <h3 className="slide-title-marketing">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-marketing prev-marketing" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-marketing" size={28} />
      </button>
      <button className="slider-btn-marketing next-marketing" onClick={goToNext}>
        <ChevronRight className="slider-icon-marketing" size={28} />
      </button>
      <div className="slider-dots-marketing">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-marketing ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

